<?php
/****************************************************
 * CONFIGURACIÓN BÁSICA
 ****************************************************/
 
// Tu token de GitHub (¡NO lo expongas en producción!):
$GITHUB_TOKEN = "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";

// Repositorio y archivo que deseas manipular:
$GITHUB_OWNER = "luisoddone";
$GITHUB_REPO  = "femon";
$GITHUB_FILE_PATH = "femon.json";   // Ruta del archivo en el repositorio
$GITHUB_BRANCH = "main";         // Rama donde está el archivo

// Definimos un User-Agent genérico y una cabecera de autorización con tu token.
$COMMON_HEADERS = [
    "User-Agent: Mi-Panel-PHP",
    "Authorization: token $GITHUB_TOKEN",
];

/****************************************************
 * FUNCIONES DE COMUNICACIÓN CON GITHUB
 ****************************************************/

/**
 * Obtiene contenido y 'sha' del archivo tv.json desde GitHub.
 * Devuelve un array con 'content' (decodificado) y 'sha'.
 */
/**
 * Obtiene contenido y 'sha' del archivo tv.json desde GitHub.
 * Devuelve un array con 'content' (decodificado), 'sha' y 'raw_response' (la respuesta cruda).
 */
/**
 * Obtiene contenido y 'sha' del archivo tv.json desde GitHub.
 * Devuelve un array con 'content' (decodificado), 'sha' y 'raw_response' (la respuesta cruda).
 */
function getJsonFromGitHub($owner, $repo, $filePath, $branch, $headers) {
    // --- PASO 1: Obtener la metadata del archivo (incluido el 'sha') ---
    $contentsUrl = "https://api.github.com/repos/$owner/$repo/contents/$filePath?ref=$branch";
    $ch = curl_init($contentsUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    if ($info['http_code'] !== 200) {
        die("Error (Paso 1) al obtener metadata del archivo. Código: {$info['http_code']}<br>Respuesta: <pre>" . htmlspecialchars($response) . "</pre>");
    }

    $data = json_decode($response, true);
    $fileSha = isset($data['sha']) ? $data['sha'] : null;

    if (!$fileSha) {
        die("No se pudo obtener el 'sha' del archivo.<br>Respuesta cruda: <pre>" . htmlspecialchars($response) . "</pre>");
    }

    // --- PASO 2: Verificar si el contenido fue incluido o si el archivo es muy grande ---
    if (isset($data['content']) && !empty($data['content'])) {
        // Archivo pequeño, el contenido ya está aquí.
        $decodedContent = base64_decode($data['content']);
        return [
            'content'      => $decodedContent,
            'sha'          => $fileSha,
            'raw_response' => $response
        ];
    } elseif ($data['size'] > 0) {
        // Archivo grande, el contenido está vacío. Hay que obtenerlo desde la API de Blobs.
        $blobUrl = "https://api.github.com/repos/$owner/$repo/git/blobs/$fileSha";
        
        $ch_blob = curl_init($blobUrl);
        curl_setopt($ch_blob, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch_blob, CURLOPT_RETURNTRANSFER, true);
        
        $blobResponse = curl_exec($ch_blob);
        $blobInfo = curl_getinfo($ch_blob);
        curl_close($ch_blob);

        if ($blobInfo['http_code'] !== 200) {
            die("Error (Paso 2) al obtener contenido del blob. Código: {$blobInfo['http_code']}<br>Respuesta: <pre>" . htmlspecialchars($blobResponse) . "</pre>");
        }

        $blobData = json_decode($blobResponse, true);
        if (isset($blobData['content'])) {
            // El contenido del blob también viene en base64.
            $decodedContent = base64_decode($blobData['content']);
            return [
                'content'      => $decodedContent,
                'sha'          => $fileSha, // Usamos el sha del primer request
                'raw_response' => $blobResponse // Mostramos la respuesta del blob que es la que tiene el contenido
            ];
        } else {
            die("La respuesta del blob no contenía el campo 'content'.<br>Respuesta: <pre>" . htmlspecialchars($blobResponse) . "</pre>");
        }
    } else {
        // Archivo vacío (0 bytes)
        return [
            'content'      => '',
            'sha'          => $fileSha,
            'raw_response' => $response
        ];
    }
}
/**
 * Actualiza el archivo tv.json en GitHub con el nuevo contenido.
 *
 * @param string $owner
 * @param string $repo
 * @param string $filePath
 * @param string $branch
 * @param string $sha           Sha actual del archivo (para no sobrescribir cambios).
 * @param string $updatedJson    El JSON final (en texto).
 * @param array  $headers
 * @return void
 */
function updateJsonInGitHub($owner, $repo, $filePath, $branch, $sha, $updatedJson, $headers) {
    $url = "https://api.github.com/repos/$owner/$repo/contents/$filePath";
    $mensajeCommit = "Actualizando $filePath via panel PHP";

    // Preparamos los datos para el PUT
    $putData = [
        "message" => $mensajeCommit,
        "content" => base64_encode($updatedJson),
        "sha"     => $sha,
        "branch"  => $branch
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($putData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge($headers, ["Content-Type: application/json"]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    if ($info['http_code'] < 200 || $info['http_code'] > 299) {
        die("Error al actualizar el archivo en GitHub. Código de respuesta: {$info['http_code']}<br>Respuesta: <pre>{$response}</pre>");
    }
}

/****************************************************
 * LÓGICA DE REORDENAMIENTO (CATEGORÍAS Y CANALES)
 ****************************************************/

/**
 * Mueve la sección (categoría) dentro del array $data
 * de la posición $indexFrom a la posición $indexTo
 */
function moveCategoryPosition(&$data, $indexFrom, $indexTo) {
    $indexFrom = intval($indexFrom);
    $indexTo   = intval($indexTo);

    if ($indexFrom < 0 || $indexFrom >= count($data) ||
        $indexTo < 0   || $indexTo >= count($data)) {
        return; // índice fuera de rango
    }
    // Sacar elemento
    $item = array_splice($data, $indexFrom, 1);
    // Insertarlo en nueva posición
    array_splice($data, $indexTo, 0, $item);
}

/**
 * Mueve el canal dentro de la sección (en $samples)
 * de la posición $oldIndex a la posición $newIndex
 */
function moveChannelPosition(&$samples, $oldIndex, $newIndex) {
    if ($oldIndex === $newIndex) return;
    if ($oldIndex < 0 || $oldIndex >= count($samples) ||
        $newIndex < 0 || $newIndex >= count($samples)) {
        return;
    }
    $item = array_splice($samples, $oldIndex, 1); // extraemos el canal
    array_splice($samples, $newIndex, 0, $item);  // lo insertamos en la nueva pos
}

/****************************************************
 * OBTENER EL JSON INICIAL DESDE GITHUB
 ****************************************************/

$jsonAndSha = getJsonFromGitHub($GITHUB_OWNER, $GITHUB_REPO, $GITHUB_FILE_PATH, $GITHUB_BRANCH, $COMMON_HEADERS);
$jsonString = $jsonAndSha['content'];
$currentSha = $jsonAndSha['sha'];

// Convertimos a array asociativo
$data = json_decode($jsonString, true);
if (!is_array($data)) {
    $data = [];
}

/**
 * Estructura esperada de $data (array):
 * [
 *   {
 *     "name": "Nombre de la Sección",
 *     "samples": [
 *        {
 *          "name": "...",
 *          "url": "...",
 *          "type": "...", // "HLS" o "CLEARKEY"
 *          "drm_license_uri": "...", // si es CLEARKEY
 *          "icono": "...",
 *          "headers": { "Referer": "...", ... } // si aplica
 *        },
 *        ...
 *     ]
 *   },
 *   ...
 * ]
 */

/****************************************************
 * PROCESAR ACCIONES DEL USUARIO (POST)
 ****************************************************/
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? $_POST['action'] : '';

    switch ($action) {

        /*********************************************
         * AGREGAR UNA NUEVA SECCIÓN
         *********************************************/
        case 'add_section':
            $newSectionName = trim($_POST['section_name']);
            if ($newSectionName !== '') {
                // Insertamos al final
                $data[] = [
                    "name" => $newSectionName,
                    "samples" => []
                ];
            }
            break;

        /*********************************************
         * ELIMINAR SECCIÓN
         *********************************************/
        case 'delete_section':
            $sectionIndex = intval($_POST['section_index']);
            if (isset($data[$sectionIndex])) {
                array_splice($data, $sectionIndex, 1);
            }
            break;

        /*********************************************
         * MOVER POSICIÓN DE LA SECCIÓN
         *********************************************/
        case 'move_section':
            $sectionIndex = intval($_POST['section_index']);
            $newPosition  = intval($_POST['new_position']) - 1; // el usuario ingresa 1-based
            moveCategoryPosition($data, $sectionIndex, $newPosition);
            break;

        /*********************************************
         * AGREGAR UN NUEVO CANAL A UNA SECCIÓN
         *********************************************/
        case 'add_channel':
            $sectionIndex = intval($_POST['section_index']);
            $channelName  = trim($_POST['channel_name']);
            $channelUrl   = trim($_POST['channel_url']);
            $channelType  = $_POST['channel_type']; // "HLS" o "CLEARKEY"
            $channelIcon  = trim($_POST['channel_icon']);

            if (isset($data[$sectionIndex])) {
                $newChannel = [
                    "name"  => $channelName,
                    "url"   => $channelUrl,
                    "type"  => $channelType,
                    "icono" => $channelIcon
                ];

                // Si es DRM, guardamos la licencia
                if ($channelType === "CLEARKEY") {
                    $drm = trim($_POST['channel_drm']);
                    $newChannel["drm_license_uri"] = $drm;
                }

                // Manejo de headers
                $hasHeaders = isset($_POST['has_headers']) ? $_POST['has_headers'] : 'no';
                if ($hasHeaders === 'yes') {
                    $headerKeys = isset($_POST['channel_header_key']) ? $_POST['channel_header_key'] : [];
                    $headerVals = isset($_POST['channel_header_val']) ? $_POST['channel_header_val'] : [];
                    $headersObj = [];
                    for ($i=0; $i < count($headerKeys); $i++) {
                        $k = trim($headerKeys[$i]);
                        $v = trim($headerVals[$i]);
                        if ($k !== '') {
                            $headersObj[$k] = $v;
                        }
                    }
                    if (!empty($headersObj)) {
                        $newChannel["headers"] = $headersObj;
                    }
                }

                $data[$sectionIndex]['samples'][] = $newChannel;
            }
            break;

        /*********************************************
         * ELIMINAR CANAL
         *********************************************/
        case 'delete_channel':
            $sectionIndex = intval($_POST['section_index']);
            $channelIndex = intval($_POST['channel_index']);
            if (isset($data[$sectionIndex]['samples'][$channelIndex])) {
                array_splice($data[$sectionIndex]['samples'], $channelIndex, 1);
            }
            break;

        /*********************************************
         * EDITAR (Y REORDENAR) CANAL
         *********************************************/
        case 'edit_channel':
            $sectionIndex = intval($_POST['section_index']);
            $channelIndex = intval($_POST['channel_index']);

            if (isset($data[$sectionIndex]['samples'][$channelIndex])) {
                $channelName  = trim($_POST['channel_name']);
                $channelUrl   = trim($_POST['channel_url']);
                $channelIcon  = trim($_POST['channel_icon']);
                $channelType  = $_POST['channel_type']; // "HLS" o "CLEARKEY"

                // Actualizamos datos básicos
                $data[$sectionIndex]['samples'][$channelIndex]['name']  = $channelName;
                $data[$sectionIndex]['samples'][$channelIndex]['url']   = $channelUrl;
                $data[$sectionIndex]['samples'][$channelIndex]['icono'] = $channelIcon;
                $data[$sectionIndex]['samples'][$channelIndex]['type']  = $channelType;

                if ($channelType === "CLEARKEY") {
                    $drm = trim($_POST['channel_drm']);
                    $data[$sectionIndex]['samples'][$channelIndex]['drm_license_uri'] = $drm;
                } else {
                    // si pasó de CLEARKEY a HLS, limpiamos el drm_license_uri
                    unset($data[$sectionIndex]['samples'][$channelIndex]['drm_license_uri']);
                }

                // Manejo de headers
                $hasHeaders = isset($_POST['has_headers']) ? $_POST['has_headers'] : 'no';
                if ($hasHeaders === 'yes') {
                    $headerKeys = isset($_POST['channel_header_key']) ? $_POST['channel_header_key'] : [];
                    $headerVals = isset($_POST['channel_header_val']) ? $_POST['channel_header_val'] : [];
                    $headersObj = [];
                    for ($i=0; $i < count($headerKeys); $i++) {
                        $k = trim($headerKeys[$i]);
                        $v = trim($headerVals[$i]);
                        if ($k !== '') {
                            $headersObj[$k] = $v;
                        }
                    }
                    $data[$sectionIndex]['samples'][$channelIndex]['headers'] = $headersObj;
                } else {
                    // Eliminar headers si es "no"
                    unset($data[$sectionIndex]['samples'][$channelIndex]['headers']);
                }

                // Reordenar la posición del canal si es necesario
                if (isset($_POST['channel_new_position'])) {
                    $channelNewPosition = intval($_POST['channel_new_position']) - 1; // de 1-based a 0-based
                    if ($channelNewPosition < 0) {
                        $channelNewPosition = 0;
                    }
                    if ($channelNewPosition >= count($data[$sectionIndex]['samples'])) {
                        $channelNewPosition = count($data[$sectionIndex]['samples']) - 1;
                    }
                    moveChannelPosition($data[$sectionIndex]['samples'], $channelIndex, $channelNewPosition);
                }
            }
            break;
    }

    // AL FINAL de cada acción: guardamos el JSON actualizado en GitHub
    // Usamos JSON_UNESCAPED_SLASHES para que no se escapen los "/"
    $finalJson = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    updateJsonInGitHub($GITHUB_OWNER, $GITHUB_REPO, $GITHUB_FILE_PATH, $GITHUB_BRANCH, $currentSha, $finalJson, $COMMON_HEADERS);

    // Redirigimos de vuelta para refrescar la página
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel de Administración - TV JSON</title>
    <style>
        body {
            background: #f0f2f5;
            margin: 0;
            padding: 0;
            font-family: sans-serif;
        }
        .container {
            width: 90%;
            max-width: 1100px;
            margin: 20px auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
        }
        h1, h2, h3 {
            text-align: center;
            margin: 10px 0;
        }
        .section-box {
            border: 1px solid #ccc;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .section-header h2 {
            margin: 0;
        }
        .channels-list {
            margin-left: 20px;
            margin-top: 10px;
        }
        .channels-list li {
            margin-bottom: 5px;
        }
        button {
            cursor: pointer;
            margin: 2px;
        }
        form {
            margin: 0;
            padding: 0;
        }
        .inline-form {
            display: inline-block;
        }
        .label-input {
            margin: 6px 0;
        }
        .input-text {
            width: 95%;
            padding: 4px;
            margin: 4px 0;
        }
        .header-pair {
            display: flex;
            gap: 5px;
            margin-bottom: 5px;
        }
        .header-pair input {
            width: 45%;
        }
        .add-header-btn {
            margin: 8px 0;
        }
        .hr-div {
            border-top: 1px solid #ccc;
            margin: 10px 0;
        }
        .small {
            font-size: 0.9em;
            color: #666;
        }
        .btn-primary {
            background: #28a745;
            color: #fff;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
        }
        .btn-danger {
            background: #dc3545;
            color: #fff;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
        }
        .btn-secondary {
            background: #007bff;
            color: #fff;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
        }
        .btn-warning {
            background: #ffc107;
            color: #333;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
        }
        .add-section-form, .add-channel-form, .edit-channel-form {
            background: #f7f7f7;
            margin: 10px 0;
            padding: 10px;
            border-radius: 5px;
        }
        .edit-channel-form {
            border: 1px solid #ccc;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Panel de Administración - TV JSON</h1>
    <p class="small">
        Editando archivo: <strong><?php echo $GITHUB_FILE_PATH; ?></strong> 
        (branch <strong><?php echo $GITHUB_BRANCH; ?></strong>)
    </p>

    
    <!-- Form para agregar nueva sección -->
    <div class="add-section-form">
        <h3>Agregar nueva categoría (sección)</h3>
        <form method="POST">
            <input type="hidden" name="action" value="add_section">
            <div class="label-input">
                <label>Nombre de la sección:</label><br>
                <input type="text" name="section_name" class="input-text" required>
            </div>
            <button type="submit" class="btn-primary">Agregar sección</button>
        </form>
    </div>

    <!-- MOSTRAR CADA SECCIÓN DEL JSON -->
    <?php foreach ($data as $sectionIndex => $section): ?>
        <div class="section-box">
            <div class="section-header">
                <h2><?php echo htmlspecialchars($section['name']); ?></h2>
                <div>
                    <!-- Eliminar sección -->
                    <form method="POST" class="inline-form">
                        <input type="hidden" name="action" value="delete_section">
                        <input type="hidden" name="section_index" value="<?php echo $sectionIndex; ?>">
                        <button type="submit" class="btn-danger" 
                                onclick="return confirm('¿Estás seguro de eliminar la sección completa?')">
                            Eliminar
                        </button>
                    </form>

                    <!-- Mover posición sección -->
                    <form method="POST" class="inline-form">
                        <input type="hidden" name="action" value="move_section">
                        <input type="hidden" name="section_index" value="<?php echo $sectionIndex; ?>">
                        <label for="pos_<?php echo $sectionIndex; ?>">Posición:</label>
                        <input type="number" name="new_position" id="pos_<?php echo $sectionIndex; ?>" 
                               value="<?php echo ($sectionIndex+1); ?>" style="width:60px;">
                        <button type="submit" class="btn-warning">Mover</button>
                    </form>
                </div>
            </div>

            <!-- LISTADO DE CANALES DE ESTA SECCIÓN -->
            <ul class="channels-list">
                <?php if (!empty($section['samples'])): ?>
                    <?php foreach ($section['samples'] as $channelIndex => $channel): ?>
                        <li>
                            <!-- Nombre canal -->
                            <strong><?php echo htmlspecialchars($channel['name']); ?></strong>
                            <!-- Botones: Eliminar / Editar -->
                            <form method="POST" class="inline-form">
                                <input type="hidden" name="action" value="delete_channel">
                                <input type="hidden" name="section_index" value="<?php echo $sectionIndex; ?>">
                                <input type="hidden" name="channel_index" value="<?php echo $channelIndex; ?>">
                                <button type="submit" class="btn-danger"
                                        onclick="return confirm('¿Eliminar este canal?')">
                                    Eliminar
                                </button>
                            </form>

                            <button type="button" class="btn-secondary" 
                                    onclick="toggleEditForm('<?php echo $sectionIndex; ?>','<?php echo $channelIndex; ?>')">
                                Editar
                            </button>

                            <!-- Formulario de edición (oculto inicialmente) -->
                            <div id="editForm_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>" 
                                 class="edit-channel-form" style="display:none;">
                                <h4>Editar canal</h4>
                                <form method="POST">
                                    <input type="hidden" name="action" value="edit_channel">
                                    <input type="hidden" name="section_index" value="<?php echo $sectionIndex; ?>">
                                    <input type="hidden" name="channel_index" value="<?php echo $channelIndex; ?>">

                                    <!-- Nombre -->
                                    <div class="label-input">
                                        <label>Nombre:</label><br>
                                        <input type="text" name="channel_name" class="input-text" 
                                               value="<?php echo htmlspecialchars($channel['name']); ?>" required>
                                    </div>

                                    <!-- URL -->
                                    <div class="label-input">
                                        <label>URL del canal:</label><br>
                                        <input type="text" name="channel_url" class="input-text"
                                               value="<?php echo htmlspecialchars($channel['url']); ?>">
                                    </div>

                                    <!-- Icono -->
                                    <div class="label-input">
                                        <label>URL del icono:</label><br>
                                        <input type="text" name="channel_icon" class="input-text"
                                               value="<?php echo isset($channel['icono']) ? htmlspecialchars($channel['icono']) : ""; ?>">
                                    </div>

                                    <!-- Tipo (HLS o CLEARKEY) -->
                                    <div class="label-input">
                                        <label>Tipo de canal:</label><br>
                                        <select name="channel_type" 
                                                onchange="toggleDrmFieldEdit('<?php echo $sectionIndex; ?>','<?php echo $channelIndex; ?>', this.value)">
                                            <option value="HLS" <?php echo ($channel['type'] === 'HLS' ? 'selected' : ''); ?>>
                                                HLS
                                            </option>
                                            <option value="CLEARKEY" <?php echo ($channel['type'] === 'CLEARKEY' ? 'selected' : ''); ?>>
                                                DRM (CLEARKEY)
                                            </option>
                                        </select>
                                    </div>

                                    <!-- DRM License (si es CLEARKEY) -->
                                    <?php 
                                        $displayDrm = ($channel['type'] === 'CLEARKEY') ? 'block' : 'none';
                                        $drmVal = isset($channel['drm_license_uri']) ? $channel['drm_license_uri'] : '';
                                    ?>
                                    <div class="label-input" 
                                         id="drmFieldEdit_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>" 
                                         style="display: <?php echo $displayDrm; ?>;">
                                        <label>URL de la licencia DRM:</label><br>
                                        <input type="text" name="channel_drm" class="input-text" 
                                               value="<?php echo htmlspecialchars($drmVal); ?>">
                                    </div>

                                    <!-- Posición del canal dentro de la sección -->
                                    <div class="label-input">
                                        <label>Nueva posición en la lista de canales (1 = primero):</label><br>
                                        <input type="number" name="channel_new_position" 
                                               value="<?php echo $channelIndex+1; ?>" style="width:80px;">
                                    </div>

                                    <!-- Headers -->
                                    <?php 
                                        $headersChecked = isset($channel['headers']) && is_array($channel['headers']);
                                    ?>
                                    <div>
                                        <label>¿Tiene headers?</label>
                                        <input type="radio" name="has_headers" value="yes"
                                               <?php echo $headersChecked ? 'checked' : ''; ?> 
                                               onclick="document.getElementById('headersEdit_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>').style.display='block';">
                                        Sí
                                        <input type="radio" name="has_headers" value="no"
                                               <?php echo !$headersChecked ? 'checked' : ''; ?>
                                               onclick="document.getElementById('headersEdit_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>').style.display='none';">
                                        No
                                    </div>

                                    <div id="headersEdit_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>" 
                                         style="display: <?php echo $headersChecked?'block':'none'; ?>;">
                                        <p>Puedes agregar o editar los headers:</p>
                                        <div id="headerPairsEdit_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>">
                                            <?php
                                            if ($headersChecked) {
                                                // mostrar cada key=>val
                                                foreach ($channel['headers'] as $hk => $hv) {
                                                    echo '<div class="header-pair">
                                                             <input type="text" name="channel_header_key[]" value="'.htmlspecialchars($hk).'" placeholder="Header..." />
                                                             <input type="text" name="channel_header_val[]" value="'.htmlspecialchars($hv).'" placeholder="Valor..." />
                                                          </div>';
                                                }
                                            } else {
                                                // ninguno: un par vacío
                                                echo '<div class="header-pair">
                                                         <input type="text" name="channel_header_key[]" placeholder="Header..." />
                                                         <input type="text" name="channel_header_val[]" placeholder="Valor..." />
                                                      </div>';
                                            }
                                            ?>
                                        </div>
                                        <button type="button" class="add-header-btn btn-secondary"
                                                onclick="addHeaderPair('headerPairsEdit_<?php echo $sectionIndex; ?>_<?php echo $channelIndex; ?>')">
                                            Agregar otro header
                                        </button>
                                    </div>

                                    <!-- Botón actualizar -->
                                    <div style="margin-top: 10px;">
                                        <button type="submit" class="btn-primary">Actualizar canal</button>
                                    </div>
                                </form>
                            </div>
                        </li>
                    <?php endforeach; ?>
                <?php else: ?>
                    <li><em>No hay canales en esta sección</em></li>
                <?php endif; ?>
            </ul>

            <!-- Formulario para agregar nuevo canal en esta sección -->
            <div class="add-channel-form">
                <h4>Agregar nuevo canal a "<?php echo htmlspecialchars($section['name']); ?>"</h4>
                <form method="POST">
                    <input type="hidden" name="action" value="add_channel">
                    <input type="hidden" name="section_index" value="<?php echo $sectionIndex; ?>">

                    <div class="label-input">
                        <label>Nombre del canal:</label><br>
                        <input type="text" name="channel_name" class="input-text" required>
                    </div>

                    <div class="label-input">
                        <label>URL del canal:</label><br>
                        <input type="text" name="channel_url" class="input-text">
                    </div>

                    <div class="label-input">
                        <label>URL del icono:</label><br>
                        <input type="text" name="channel_icon" class="input-text">
                    </div>

                    <div class="label-input">
                        <label>¿El canal es HLS o con DRM?</label><br>
                        <select name="channel_type" onchange="toggleDrmField(this, '<?php echo $sectionIndex; ?>')">
                            <option value="HLS">HLS</option>
                            <option value="CLEARKEY">DRM (CLEARKEY)</option>
                        </select>
                    </div>

                    <div class="label-input" id="drmField_<?php echo $sectionIndex; ?>" style="display:none;">
                        <label>URL de la licencia DRM:</label><br>
                        <input type="text" name="channel_drm" class="input-text">
                    </div>

                    <!-- Headers -->
                    <div>
                        <label>¿Este canal requiere headers?</label>
                        <input type="radio" name="has_headers" value="yes"
                               onclick="document.getElementById('headersContainer_<?php echo $sectionIndex; ?>').style.display='block';">
                        Sí
                        <input type="radio" name="has_headers" value="no" checked
                               onclick="document.getElementById('headersContainer_<?php echo $sectionIndex; ?>').style.display='none';">
                        No
                    </div>
                    <div id="headersContainer_<?php echo $sectionIndex; ?>" style="display:none;">
                        <p>Puedes agregar tantos headers (key/value) como necesites:</p>
                        <div id="headerPairs_<?php echo $sectionIndex; ?>">
                            <div class="header-pair">
                                <input type="text" name="channel_header_key[]" placeholder="Header..." />
                                <input type="text" name="channel_header_val[]" placeholder="Valor..." />
                            </div>
                        </div>
                        <button type="button" class="add-header-btn btn-secondary" 
                                onclick="addHeaderPair('headerPairs_<?php echo $sectionIndex; ?>')">
                            Agregar otro header
                        </button>
                    </div>

                    <div style="margin-top: 10px;">
                        <button type="submit" class="btn-primary">Agregar canal</button>
                    </div>
                </form>
            </div>
        </div>
    <?php endforeach; ?>

</div>

<script>
// Mostrar/ocultar formulario de edición de un canal
function toggleEditForm(sectionIndex, channelIndex) {
    var elem = document.getElementById('editForm_' + sectionIndex + '_' + channelIndex);
    if (elem.style.display === 'none') {
        elem.style.display = 'block';
    } else {
        elem.style.display = 'none';
    }
}

// Mostrar/ocultar campo DRM en el formulario de AGREGAR
function toggleDrmField(selectElem, sectionIndex) {
    var drmDiv = document.getElementById('drmField_' + sectionIndex);
    if (!drmDiv) return;
    if (selectElem.value === 'CLEARKEY') {
        drmDiv.style.display = 'block';
    } else {
        drmDiv.style.display = 'none';
    }
}

// Mostrar/ocultar campo DRM en el formulario de EDITAR
function toggleDrmFieldEdit(sectionIndex, channelIndex, value) {
    var drmDiv = document.getElementById('drmFieldEdit_' + sectionIndex + '_' + channelIndex);
    if (!drmDiv) return;
    if (value === 'CLEARKEY') {
        drmDiv.style.display = 'block';
    } else {
        drmDiv.style.display = 'none';
    }
}

// Agregar dinámicamente un par key/value para los headers
function addHeaderPair(containerId) {
    var container = document.getElementById(containerId);
    if (!container) return;
    var div = document.createElement('div');
    div.className = 'header-pair';
    div.innerHTML = '<input type="text" name="channel_header_key[]" placeholder="Header..." /> '+
                    '<input type="text" name="channel_header_val[]" placeholder="Valor..." />';
    container.appendChild(div);
}
</script>

</body>
</html>
