const express = require("express");
const cors = require("cors");
const admin = require("firebase-admin");
const serviceAccount = require("./serviceAccountKey.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
  databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
});

const app = express();
app.use(cors());
app.use(express.json());

// Logger para ver por d贸nde entra el reques
app.use((req, res, next) => {
  console.log(req.method, req.url);
  next();
});

// ENDPOINT: Cambiar contrase帽a de usuario
app.post("/api/changePassword", async (req, res) => {
  console.log("POST /api/changePassword");
  const { uid, newPassword } = req.body;
  try {
    await admin.auth().updateUser(uid, { password: newPassword });
    res.json({ success: true, endpoint: "/api/changePassword" });
  } catch (err) {
    res.status(400).json({ success: false, error: err.message, endpoint: "/api/changePassword" });
  }
});

// ENDPOINT: Obtener metadata de usuario (fecha de creaci贸n)
app.get("/api/getUserMetadata", async (req, res) => {
  const { uid } = req.query;
  if (!uid) {
    return res.status(400).json({ error: "Falta par谩metro uid" });
  }
  try {
    const userRecord = await admin.auth().getUser(uid);
    // Firebase devuelve creationTime como string, ej: "Mon, 27 May 2024 00:18:25 GMT"
    res.json({ creationTime: userRecord.metadata.creationTime });
  } catch (err) {
    console.error("Error al obtener metadata:", err.message);
    res.status(500).json({ error: "No se pudo obtener metadata" });
  }
});

// Prueba de vida
app.get("/", (req, res) => {
  res.send("API online");
});

const PORT = process.env.PORT || 3020;
app.listen(PORT, () => {
  console.log(`🔥  API admin escuchando en puerto ${PORT}`);
});