import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
import { getAuth, onAuthStateChanged } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js";
import { getDatabase, ref, get, update } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

// Configuración de Firebase
const firebaseConfig = {
    apiKey: "AIzaSyDKjEeCh8-4Bukh0CgJKS5RQlD_gh70FOc",
    authDomain: "playtv-a8085.firebaseapp.com",
    databaseURL: "https://playtv-a8085-default-rtdb.firebaseio.com",
    projectId: "playtv-a8085",
    storageBucket: "playtv-a8085.firebasestorage.app",
    messagingSenderId: "887768250224",
    appId: "1:887768250224:web:804417ad84193dfbce01b5"
};

const app = initializeApp(firebaseConfig);
const auth = getAuth(app);
const database = getDatabase(app);

const listaUsuarios = document.getElementById("listaUsuarios");
const buscarCorreo = document.getElementById("buscarCorreo");

let adminUID = null;

// Verificar si el administrador está autenticado
onAuthStateChanged(auth, (user) => {
    if (user) {
        adminUID = user.uid;
        cargarUsuarios();
    } else {
        alert("No estás autenticado. Redirigiendo...");
        window.location.href = "index.html";
    }
});

// Función para convertir fechas al formato correcto sin coma
function convertirFecha(fechaStr) {
    try {
        const [dia, mes, anioHora] = fechaStr.split("/");
        const [anio, hora] = anioHora.split(" ");
        const fechaISO = `${anio}-${mes}-${dia}T${hora}`;
        const fecha = new Date(fechaISO);

        if (isNaN(fecha.getTime())) throw new Error("Formato inválido");

        // Formatear fecha en el formato "dd/MM/yyyy HH:mm:ss"
        return `${fecha.getDate().toString().padStart(2, "0")}/${(fecha.getMonth() + 1)
            .toString()
            .padStart(2, "0")}/${fecha.getFullYear()} ${fecha
            .getHours()
            .toString()
            .padStart(2, "0")}:${fecha.getMinutes().toString().padStart(2, "0")}:${fecha
            .getSeconds()
            .toString()
            .padStart(2, "0")}`;
    } catch {
        return null;
    }
}

// Cargar usuarios creados por el administrador
async function cargarUsuarios() {
    const usuariosRef = ref(database, "usuarios");
    const snapshot = await get(usuariosRef);

    if (snapshot.exists()) {
        const usuarios = snapshot.val();
        listaUsuarios.innerHTML = "";

        // Filtrar usuarios por idv (UID del admin)
        for (const uid in usuarios) {
            const usuario = usuarios[uid];
            if (usuario.idv === adminUID) {
                const usuarioDiv = document.createElement("div");
                usuarioDiv.classList.add("usuario");

                const fechaCreacion = convertirFecha(usuario.creacion);
                const fechaVencimiento = convertirFecha(usuario.vencimiento);

                usuarioDiv.innerHTML = `
                    <p>Correo: ${usuario.email}</p>
                    <p>Vencimiento: ${fechaVencimiento || "Fecha inválida"}</p>
                    <p>Contraseña: ${usuario.password}</p>
                    <p>Creación: ${fechaCreacion || "Fecha inválida"}</p>
                    <hr />
                `;
                usuarioDiv.addEventListener("contextmenu", (e) => mostrarOpciones(e, uid, usuario));
                listaUsuarios.appendChild(usuarioDiv);
            }
        }
    } else {
        listaUsuarios.innerHTML = "<p>No se encontraron usuarios creados por este administrador.</p>";
    }
}

// Mostrar opciones al hacer clic derecho
function mostrarOpciones(event, uid, usuario) {
    event.preventDefault();

    const menu = document.createElement("div");
    menu.classList.add("menu-contextual");
    menu.innerHTML = `
        <button onclick="renovarCuenta('${uid}', '${usuario.vencimiento}')">Renovar Cuenta</button>
        <button onclick="eliminarDeviceID('${uid}')">Reiniciar Device ID</button>
        <button onclick="copiarUsuario('${usuario.email}', '${usuario.password}')">Copiar Usuario Creado</button>
    `;
    document.body.appendChild(menu);

    menu.style.top = `${event.clientY}px`;
    menu.style.left = `${event.clientX}px`;

    document.addEventListener("click", () => menu.remove(), { once: true });
}

// Función para renovar cuenta
window.renovarCuenta = async function (uid, vencimientoActual) {
    // Limpiar cualquier coma en el formato actual
    const vencimientoLimpio = vencimientoActual.replace(",", "");
    const fechaActual = convertirFecha(vencimientoLimpio);

    if (!fechaActual) {
        alert("Fecha de vencimiento inválida.");
        return;
    }

    const fecha = new Date(fechaActual);
    fecha.setMonth(fecha.getMonth() + 1);

    const nuevaFecha = `${fecha.getDate().toString().padStart(2, "0")}/${(fecha.getMonth() + 1)
        .toString()
        .padStart(2, "0")}/${fecha.getFullYear()} ${fecha
        .getHours()
        .toString()
        .padStart(2, "0")}:${fecha.getMinutes().toString().padStart(2, "0")}:${fecha
        .getSeconds()
        .toString()
        .padStart(2, "0")}`;

    const usuarioRef = ref(database, `usuarios/${uid}`);
    await update(usuarioRef, { vencimiento: nuevaFecha });

    alert(`Cuenta renovada. Nuevo vencimiento: ${nuevaFecha}`);
    cargarUsuarios();
};

// Función para eliminar Device ID
window.eliminarDeviceID = async function (uid) {
    const deviceIDRef = ref(database, `usuarios/${uid}/deviceID`);
    await remove(deviceIDRef);

    alert("Device ID eliminado.");
    cargarUsuarios();
};

// Función para copiar usuario creado
window.copiarUsuario = function (email, password) {
    const texto = `Correo: ${email}\nContraseña: ${password}`;
    navigator.clipboard.writeText(texto).then(() => {
        alert("Usuario copiado al portapapeles.");
    });
};

// Filtrar usuarios por correo electrónico
buscarCorreo.addEventListener("input", () => {
    const filtro = buscarCorreo.value.toLowerCase();
    const usuarios = document.querySelectorAll(".usuario");

    usuarios.forEach((usuario) => {
        const correo = usuario.querySelector("p:first-child").textContent.toLowerCase();
        usuario.style.display = correo.includes(filtro) ? "" : "none";
    });
});
