<?php
header('Content-Type: text/html; charset=UTF-8');
date_default_timezone_set('America/Asuncion');
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Panel – Cambiar contraseña de Admins</title>
<style>
  body{font-family:Arial,Helvetica,sans-serif;background:#000;color:#fff;margin:0;user-select:none}
  /* --- Tarjeta principal --- */
  .card{max-width:760px;margin:20px auto;background:rgba(255,255,255,.07);padding:22px;border-radius:10px}
  h1{margin:0 0 20px;text-align:center}
  #buscar{width:100%;padding:10px;border:1px solid #777;border-radius:5px;background:#111;color:#fff}
  .fila{display:grid;grid-template-columns:1fr auto;gap:10px;align-items:center;padding:12px 0;border-bottom:1px solid #444}
  .fila span{word-break:break-all}
  .fila button{background:#111;border:1px solid #fff;color:#fff;border-radius:5px;padding:6px 14px;cursor:pointer}
  .fila button:hover{background:#444}
  .acciones{display:flex;flex-direction:column;gap:8px}
  .acciones button.danger{border:1px solid #ff6b6b;color:#ff6b6b}
  .acciones button.danger:hover{background:#440000}

  /* --- Login y código --- */
  .login{max-width:340px;margin:100px auto;background:rgba(255,255,255,.07);padding:24px;border-radius:10px;text-align:center}
  .login h2{margin-top:0}
  .login input{width:100%;padding:10px;margin:8px 0;border:1px solid #777;border-radius:5px;background:#111;color:#fff}
  .login button{width:100%;padding:10px;background:#111;border:1px solid #fff;color:#fff;border-radius:5px;cursor:pointer}
  .login button:hover{background:#444}
  .err{color:#ff6b6b;font-size:.9em;margin-top:8px;min-height:1em}

  .gate-note{color:#bbb;font-size:.95em;line-height:1.5;margin-bottom:10px}

  /* Oculta el panel y login mientras el código no se valida */
  .hidden{display:none !important}

  @media(max-width:600px){
    .fila{grid-template-columns:100%}
    .fila button{margin-top:8px;width:100%}
  }
</style>
</head>
<body>
  <!-- Código de administrador -->
  <div class="login" id="gateBox">
    <h2>Código de administrador</h2>
    <p class="gate-note">Ingresa el código de acceso para gestionar administradores.</p>
    <input id="gateCode" type="password" placeholder="Código de acceso" autocomplete="one-time-code" autofocus>
    <button id="btnGate">Continuar</button>
    <div class="err" id="gateErr"></div>
  </div>

  <!-- Formulario de login -->
  <div class="login hidden" id="loginBox">
    <h2>Iniciar sesión</h2>
    <input id="email"  type="email"    placeholder="Correo" autocomplete="username" value="femonplay">
    <input id="clave"  type="password" placeholder="Contraseña" autocomplete="current-password" value="2161140">
    <button id="btnLogin">Entrar</button>
    <div class="err" id="errBox"></div>
  </div>

  <!-- Panel de administradores -->
  <div class="card hidden" id="panelBox">
    <h1>Administradores (UID-based)</h1>
    <input id="buscar" placeholder="Buscar correo…" autocomplete="off">
    <div id="lista"></div>
    <button id="btnSalir" style="margin-top:18px;width:100%">Cerrar sesión</button>
  </div>

<script type="module">
import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
import { getAuth, onAuthStateChanged, signInWithEmailAndPassword, signOut } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js";
import { getDatabase, ref, get, update, set, remove } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

/* ----------  Config del proyecto playtvpro-9a9cc  ---------- */
const firebaseConfig = {
    apiKey: "AIzaSyADcEYKamrewxL8CDA8NmAuRZjp8eZ2XzY",
    authDomain: "femon-play.firebaseapp.com",
    databaseURL: "https://femon-play-default-rtdb.firebaseio.com",
    projectId: "femon-play",
    storageBucket: "femon-play.appspot.com",
    messagingSenderId: "887768250224",
    appId: "1:63456783638:android:1e18d5484b58fc1411f437"
};

const app  = initializeApp(firebaseConfig);
const auth = getAuth(app);
const db   = getDatabase(app);
const PATH = "Admin";
const MESSAGE_ROOT = "adminMessages";

/* ----------  DOM ---------- */
const gateBox    = document.getElementById("gateBox");
const gateCode   = document.getElementById("gateCode");
const gateErr    = document.getElementById("gateErr");
const btnGate    = document.getElementById("btnGate");

const loginBox   = document.getElementById("loginBox");
const emailInput = document.getElementById("email");
const passInput  = document.getElementById("clave");
const btnLogin   = document.getElementById("btnLogin");
const errBox     = document.getElementById("errBox");

const panelBox = document.getElementById("panelBox");
const lista    = document.getElementById("lista");
const buscar   = document.getElementById("buscar");
const btnSalir = document.getElementById("btnSalir");
buscar.oninput = filtrar;

const ACCESS_CODE = "2161140";
let gateUnlocked = false;

// Garantiza que nadie intente autenticarse sin validar el código de acceso
function assertGate(){
  if(!gateUnlocked){
    gateErr.textContent = "Primero ingresa el código de administrador";
    gateCode.focus();
    return false;
  }
  return true;
}

// Estado inicial de visibilidad
gateBox.classList.remove("hidden");
loginBox.classList.add("hidden");
panelBox.classList.add("hidden");

btnGate.onclick = ()=>{
  gateErr.textContent = "";
  const code = gateCode.value.trim();
  if(code !== ACCESS_CODE){
    gateErr.textContent = "Código incorrecto";
    gateCode.focus();
    return;
  }
  gateUnlocked = true;
  gateBox.classList.add("hidden");
  loginBox.classList.remove("hidden");
  emailInput.focus();
};

/* ----------  Estado de Auth ---------- */
onAuthStateChanged(auth, user=>{
  if(user){
    if(gateUnlocked){
      loginBox.classList.add("hidden");
      panelBox.classList.remove("hidden");
      gateBox.classList.add("hidden");
      cargarAdmins();
      return;
    }
    // Si llega un usuario sin validar el código, cerramos la sesión de inmediato
    signOut(auth);
    gateErr.textContent = "Se requiere el código de administrador antes de acceder.";
    gateBox.classList.remove("hidden");
    loginBox.classList.add("hidden");
    panelBox.classList.add("hidden");
  }else{
    panelBox.classList.add("hidden");
    if(gateUnlocked){
      gateBox.classList.add("hidden");
      loginBox.classList.remove("hidden");
      emailInput.focus();
    }else{
      gateBox.classList.remove("hidden");
      loginBox.classList.add("hidden");
    }
    lista.innerHTML = "";
  }
});

/* ----------  Login manual ---------- */
btnLogin.onclick = async ()=>{
  errBox.textContent = "";
  if(!assertGate()) return;
  const email = emailInput.value.trim();
  const pass  = passInput.value.trim();
  if(!email || !pass){ errBox.textContent = "Completa ambos campos"; return; }

  try{
    await signInWithEmailAndPassword(auth, email, pass);
    // onAuthStateChanged se encargará del resto
  }catch(err){
    errBox.textContent = "Error: "+mensajeError(err.code);
  }
};

/* ----------  Logout ---------- */
btnSalir.onclick = ()=> signOut(auth);

/* ----------  Traductor de errores ---------- */
function mensajeError(code){
  switch(code){
    case "auth/invalid-email":       return "Correo inválido";
    case "auth/user-not-found":      return "Usuario no encontrado";
    case "auth/wrong-password":      return "Contraseña incorrecta";
    case "auth/too-many-requests":   return "Demasiados intentos, espera un momento";
    default:                         return code.replace("auth/","").replaceAll("-"," ");
  }
}

/* ----------  Cargar y dibujar ---------- */
function esc(str=""){
  return String(str).replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/`/g,"\u0060");
}

async function cargarAdmins(){
  lista.textContent = "Cargando…";
  lista.innerHTML   = "";

  try{
    const snap = await get(ref(db, PATH));
    if(!snap.exists()){ lista.textContent = "Sin registros en Admin/"; return; }

    Object.entries(snap.val()).forEach(([uid,data])=>{
      if(!data.email) return;
      const row = document.createElement("div");
      row.className = "fila";
      const creadorEmail = data.creadoPor || data.creador || data.vendedor || "";
      const creadorId    = data.idv || "";
      row.dataset.filter = `${data.email} ${creadorEmail} ${creadorId}`.toLowerCase();

      /* -------------- CORREGIDO: usar template literal -------------- */
      row.innerHTML = `
        <span>
          <b>${data.email}</b><br>
          <small style="opacity:.7">UID: ${uid}</small><br>
          <small style="opacity:.7">Creador: ${creadorEmail || "Sin asignar"}</small><br>
          <small style="opacity:.7">ID del creador: ${creadorId || "Sin asignar"}</small>
        </span>
        <div class="acciones">
          <button onclick="cambiarPw('${esc(uid)}','${esc(data.email)}')">Cambiar contraseña</button>
          <button onclick="gestionarCreador('${esc(uid)}','${esc(creadorEmail)}','${esc(creadorId)}')">${creadorEmail ? "Cambiar" : "Asignar"} creador</button>
          <button onclick="enviarMensajeVendedor('${esc(uid)}','${esc(data.email)}')">Enviar mensaje</button>
          <button class="danger" onclick="eliminarMensajeVendedor('${esc(uid)}','${esc(data.email)}')">Eliminar mensaje</button>
        </div>
      `;
      /* -------------------------------------------------------------- */

      lista.appendChild(row);
    });
    filtrar();
  }catch(err){
    console.error(err);
    lista.textContent = "Error al leer la base";
  }
}

/* ----------  Filtro simple ---------- */
function filtrar(){
  const t = buscar.value.toLowerCase();
  lista.querySelectorAll(".fila").forEach(f=>{
    const contenido = f.dataset.filter || "";
    f.style.display = contenido.includes(t) ? "" : "none";
  });
}

/* ----------  Cambiar contraseña via UID ---------- */
async function cambiarPw(uid,email){
  /* ---------- CORREGIDO: texto del prompt entre back-ticks ---------- */
  let nueva = prompt(`Nueva contraseña para\n${email}:`);
  /* ----------------------------------------------------------------- */
  if(!nueva || !(nueva = nueva.trim())) return alert("Contraseña inválida");

  try{
    const idTok = await auth.currentUser.getIdToken(true);
    const r = await fetch("/api/changePassword",{
      method:"POST",
      headers:{
        "Content-Type":"application/json",
        "Authorization":"Bearer "+idTok
      },
      body: JSON.stringify({ uid, newPassword: nueva })
    });
    const j = await r.json();
    if(!j.success) throw new Error(j.error||"Fallo desconocido");
    alert("Contraseña actualizada correctamente");
  }catch(err){
    alert("No se pudo cambiar: "+err.message);
  }
}
window.cambiarPw = cambiarPw;

/* ----------  Asignar o modificar creador ---------- */
async function gestionarCreador(uid, actualEmail = "", actualId = ""){ 
  const prefEmail = actualEmail ? `Actual: ${actualEmail}\n` : "";
  const emailEntrada = prompt(`${prefEmail}Ingresa el correo del creador asociado:`);
  if(emailEntrada === null) return;
  const email = emailEntrada.trim();
  if(!email){
    alert("Debe ingresar un correo de creador válido");
    return;
  }

  const prefId = actualId ? `Actual: ${actualId}\n` : "";
  const idEntrada = prompt(`${prefId}Ingresa el ID del creador:`);
  if(idEntrada === null) return;
  const idVal = idEntrada.trim();
  if(!idVal){
    alert("Debe ingresar un ID de creador válido");
    return;
  }

  try{
    await update(ref(db, `${PATH}/${uid}`), { creadoPor: email, idv: idVal });
    alert("Creador actualizado correctamente");
    cargarAdmins();
  }catch(err){
    alert("No se pudo actualizar el creador: "+err.message);
  }
}
window.gestionarCreador = gestionarCreador;

/* ----------  Mensajes para vendedores ---------- */
async function enviarMensajeVendedor(uid, email){
  const entrada = prompt(`Escribe el mensaje para ${email}:`);
  if(entrada === null) return;
  const texto = entrada.trim();
  if(!texto){
    alert("Debes escribir un mensaje válido");
    return;
  }

  try{
    const payload = {
      text: texto,
      createdAt: Date.now()
    };
    const usuario = auth.currentUser;
    if(usuario && usuario.email) payload.author = usuario.email;
    await set(ref(db, `${MESSAGE_ROOT}/${uid}`), payload);
    alert(`Mensaje enviado correctamente a ${email}`);
  }catch(err){
    console.error(err);
    alert("No se pudo enviar el mensaje: "+err.message);
  }
}

async function eliminarMensajeVendedor(uid, email){
  if(!confirm(`¿Eliminar el mensaje para ${email}?`)) return;

  try{
    await remove(ref(db, `${MESSAGE_ROOT}/${uid}`));
    alert(`Mensaje eliminado para ${email}`);
  }catch(err){
    console.error(err);
    alert("No se pudo eliminar el mensaje: "+err.message);
  }
}
window.enviarMensajeVendedor = enviarMensajeVendedor;
window.eliminarMensajeVendedor = eliminarMensajeVendedor;
</script>
</body>
</html>
