<?php
// Autocarga de Composer (requiere vlucas/phpdotenv)
require __DIR__ . '/vendor/autoload.php';

use Dotenv\Dotenv;

// Carga variables de entorno
$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

// Definir credenciales
define('PANEL_USER', $_ENV['PANEL_USER']);
define('PANEL_PASS', $_ENV['PANEL_PASS']);

// Iniciar sesión
session_start();

// Procesar formulario de login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $u = $_POST['user'] ?? '';
    $p = $_POST['pass'] ?? '';
    if ($u === PANEL_USER && $p === PANEL_PASS) {
        $_SESSION['logged_in'] = true;
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $error = 'Usuario o contraseña incorrectos.';
    }
}

// Si no está autenticado, mostramos login
if (empty($_SESSION['logged_in'])):
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Login - Panel Películas</title>
  <style>
    body{display:flex;align-items:center;justify-content:center;height:100vh;margin:0;background:#f2f2f2;}
    .box{background:#fff;padding:20px;border-radius:6px;box-shadow:0 0 10px rgba(0,0,0,0.1);}
    input{width:100%;padding:10px;margin:8px 0;border:1px solid #ccc;border-radius:4px;}
    button{width:100%;padding:10px;background:#007bff;color:#fff;border:none;border-radius:4px;cursor:pointer;}
    .error{color:#d9534f;margin-bottom:10px;}
  </style>
</head>
<body>
  <div class="box">
    <h2>Acceso Panel Películas</h2>
    <?php if(!empty($error)): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
      <input type="text" name="user" placeholder="Usuario" required autofocus>
      <input type="password" name="pass" placeholder="Contraseña" required>
      <button type="submit" name="login">Ingresar</button>
    </form>
  </div>
</body>
</html>
<?php
  exit;
endif;

/***************************************
 * Configuraciones iniciales
 **************************************/
// --- Archivo JSON local ---
$jsonFilePathLocal = 'pelis.json';

// API Key de TMDb
$tmdbApiKey = 'eac6b66d86771fe225dfc28551bde098';

// Archivos-bandera (flags) para operaciones de uso único
$updateFlagFile = __DIR__ . '/.update_done';
$encryptionFlagFile = __DIR__ . '/.encryption_done';

// Credenciales de encriptación
define('ENCRYPTION_KEY', 'e72of82ke0gu2o2k');
define('ENCRYPTION_METHOD', 'aes-128-ecb');

/***************************************
 * Funciones de Encriptación / Desencriptación
 **************************************/
function encryptUrl($plaintext) {
    if (empty($plaintext)) return '';
    // Evita doble encriptación
    if (base64_decode($plaintext, true) !== false && openssl_decrypt(base64_decode($plaintext), ENCRYPTION_METHOD, ENCRYPTION_KEY) !== false) {
        return $plaintext;
    }
    $encrypted = openssl_encrypt($plaintext, ENCRYPTION_METHOD, ENCRYPTION_KEY);
    return base64_encode($encrypted);
}

function decryptUrl($ciphertext) {
    if (empty($ciphertext)) return '';
    $decoded_ciphertext = base64_decode($ciphertext, true);
    if ($decoded_ciphertext === false) {
        return $ciphertext; // No es base64, es una URL no encriptada
    }
    $decrypted = openssl_decrypt($decoded_ciphertext, ENCRYPTION_METHOD, ENCRYPTION_KEY);
    return $decrypted !== false ? $decrypted : $ciphertext; // Si falla, devolvemos el original
}

/***************************************
 * Funciones de manejo de JSON (Local)
 **************************************/

// Carga el JSON desde el archivo local
function loadLocalJson($filePath) {
    if (!file_exists($filePath)) return [];
    $content = file_get_contents($filePath);
    $data = json_decode($content, true);
    return is_array($data) ? $data : [];
}

// Guarda el array en el archivo JSON local (SIEMPRE encriptado)
function saveLocalJson($filePath, $dataArray) {
    $jsonString = json_encode($dataArray, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    return file_put_contents($filePath, $jsonString) !== false;
}

// Función central para guardar los datos (ahora solo localmente)
function saveAllData($data, $message) {
    global $jsonFilePathLocal;
    // Guardar en el hosting local (encriptado).
    // El array $data ya contiene las URLs encriptadas por la lógica de la aplicación.
    return saveLocalJson($jsonFilePathLocal, $data);
}


/***************************************
 * Funciones de TMDb
 **************************************/
function searchMovieTMDB($q,$key){$url="https://api.themoviedb.org/3/search/movie?api_key=$key&query=".urlencode($q)."&include_adult=false&language=es-ES";$data=json_decode(file_get_contents($url),true);return $data['results'] ?? [];}
function getMovieDetails($id,$key){$url="https://api.themoviedb.org/3/movie/$id?api_key=$key&language=es-ES&append_to_response=images&include_image_language=es,null,en";return json_decode(file_get_contents($url),true);}
function enrichMovieArray(&$m,$key){if(!empty($m['descripcion']??'')) return;$r=searchMovieTMDB($m['name'],$key);if(empty($r)) return;$d=getMovieDetails($r[0]['id'],$key); if(empty($d)) return;$m['descripcion']=$d['overview']??'';$m['anio']=substr($d['release_date']??'',0,4);$m['duracion']=($d['runtime']??0)?$d['runtime'].' min':'';$m['genero']=!empty($d['genres'])?implode(', ',array_column($d['genres'],'name')):'';$m['iconoHorizontal']=!empty($d['backdrop_path'])?'https://image.tmdb.org/t/p/original'.$d['backdrop_path']:'';$icon='';if(!empty($d['images']['logos'])){$logos=$d['images']['logos'];foreach(['es','en'] as $lg){foreach($logos as $l){if($l['iso_639_1']===$lg){$icon='https://image.tmdb.org/t/p/w500'.$l['file_path'];break 2;}}}if(!$icon) $icon='https://image.tmdb.org/t/p/w500'.$logos[0]['file_path'];}$m['iconpng']=$icon;}

/***************************************
 * Cargar JSON inicial (Solo Local)
 **************************************/
// Cargar el JSON directamente desde el archivo local.
$jsonArray = loadLocalJson($jsonFilePathLocal);


/***************************************
 * Variables de uso general
 **************************************/
$errorMsg="";$successMsg="";$searchResults=[];$selectedMovie=null;$showJsonEditor=false;$jsonStringForTextarea='';

/***************************************
 * Acción: Encriptación masiva de URLs (uso único)
 **************************************/
if (isset($_GET['action']) && $_GET['action'] === 'encryptAll' && !file_exists($encryptionFlagFile)) {
    foreach ($jsonArray as &$category) {
        if (isset($category['samples'])) {
            foreach ($category['samples'] as &$movie) {
                if (isset($movie['url'])) $movie['url'] = encryptUrl($movie['url']);
            }
        }
    }
    unset($category, $movie);

    if (saveAllData($jsonArray, 'Encriptación masiva de URLs')) {
        $successMsg = '¡Todas las URLs han sido encriptadas correctamente!';
        file_put_contents($encryptionFlagFile, 'done');
    } else {
        $errorMsg = 'Ocurrió un problema al guardar el archivo JSON encriptado.';
    }
}

/***************************************
 * Acción: Actualización masiva de datos (TMDb)
 **************************************/
if(isset($_GET['action']) && $_GET['action']==='runUpdate' && !file_exists($updateFlagFile)){
    foreach($jsonArray as &$c){foreach($c['samples'] as &$m){enrichMovieArray($m,$tmdbApiKey);}} unset($c,$m);
    if(saveAllData($jsonArray, 'Actualización masiva de películas')){
        $successMsg='Todas las películas fueron enriquecidas correctamente.';
        file_put_contents($updateFlagFile,'done');
    }else{$errorMsg='Ocurrió un problema al actualizar el JSON.';}
}

/***************************************
 * Acción: Eliminar Película
 **************************************/
if(isset($_GET['action'])&&$_GET['action']==='deleteMovie'){
    $c=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);
    if($c>=0 && isset($jsonArray[$c]['samples'][$m])){
        $name=$jsonArray[$c]['samples'][$m]['name'];
        array_splice($jsonArray[$c]['samples'],$m,1);
        if(saveAllData($jsonArray, "Eliminando película: $name")){
            $successMsg="Película '$name' eliminada correctamente.";
        }else{$errorMsg='Error al eliminar la película.';}
    }
}

/***************************************
 * Mover/duplicar películas entre categorías
 **************************************/
$moveMovieData=null;$duplicateMovieData=null;
if(isset($_GET['action'])&&$_GET['action']==='showMoveMovieForm'){$c=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);if($c>=0&&isset($jsonArray[$c]['samples'][$m])){$moveMovieData=['catIndex'=>$c,'movieIndex'=>$m,'name'=>$jsonArray[$c]['samples'][$m]['name']];}}
elseif(isset($_GET['action'])&&$_GET['action']==='showDuplicateMovieForm'){$c=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);if($c>=0&&isset($jsonArray[$c]['samples'][$m])){$duplicateMovieData=['catIndex'=>$c,'movieIndex'=>$m,'name'=>$jsonArray[$c]['samples'][$m]['name']];}}
elseif(isset($_GET['action'])&&$_GET['action']==='moveToCategory'){$from=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);$to=(int)($_GET['targetCat']??-1);if($from>=0&&$to>=0&&isset($jsonArray[$from]['samples'][$m])&&isset($jsonArray[$to])){$obj=$jsonArray[$from]['samples'][$m];array_splice($jsonArray[$from]['samples'],$m,1);$jsonArray[$to]['samples'][]=$obj;if(saveAllData($jsonArray, "Moviendo película: {$obj['name']}")){$successMsg="Película '{$obj['name']}' movida a '{$jsonArray[$to]['name']}'.";}else{$errorMsg='Error al mover la película.';}}}
elseif(isset($_GET['action'])&&$_GET['action']==='duplicateToCategory'){$from=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);$to=(int)($_GET['targetCat']??-1);if($from>=0&&$to>=0&&isset($jsonArray[$from]['samples'][$m])&&isset($jsonArray[$to])){$obj=$jsonArray[$from]['samples'][$m];$jsonArray[$to]['samples'][]=$obj;if(saveAllData($jsonArray, "Duplicando película: {$obj['name']}")){$successMsg="Película '{$obj['name']}' duplicada en '{$jsonArray[$to]['name']}'.";}else{$errorMsg='Error al duplicar la película.';}}}

/***************************************
 * Mover categorías y películas (orden)
 **************************************/
if(isset($_GET['action'])&&$_GET['action']==='moveCategory'){$idx=(int)($_GET['index']??-1);$dir=$_GET['dir']??'';if($idx>=0&&$idx<count($jsonArray)){if($dir==='up'&&$idx>0){[$jsonArray[$idx-1],$jsonArray[$idx]]=[$jsonArray[$idx],$jsonArray[$idx-1]];}elseif($dir==='down'&&$idx<count($jsonArray)-1){[$jsonArray[$idx],$jsonArray[$idx+1]]=[$jsonArray[$idx+1],$jsonArray[$idx]];}if(saveAllData($jsonArray, 'Moviendo categoría')){$successMsg='Categoría movida.';}else{$errorMsg='Error al mover categoría.';}}}
if(isset($_GET['action'])&&$_GET['action']==='moveMovie'){$c=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);$dir=$_GET['dir']??'';if($c>=0&&$c<count($jsonArray)){$s=&$jsonArray[$c]['samples'];if($m>=0&&$m<count($s)){if($dir==='up'&&$m>0){[$s[$m-1],$s[$m]]=[$s[$m],$s[$m-1]];}elseif($dir==='down'&&$m<count($s)-1){[$s[$m],$s[$m+1]]=[$s[$m+1],$s[$m]];}if(saveAllData($jsonArray, 'Moviendo película')){$successMsg='Película movida.';}else{$errorMsg='Error al mover película.';}}}}

/***************************************
 * Búsqueda TMDb
 **************************************/
if(isset($_GET['action'])&&$_GET['action']==='search'&&!empty($_GET['query'])){$searchResults=searchMovieTMDB(trim($_GET['query']),$tmdbApiKey);}
if(isset($_GET['action'])&&$_GET['action']==='select'&&!empty($_GET['id'])){$tid=(int)$_GET['id'];$st=$_GET['st']??'';$d=getMovieDetails($tid,$tmdbApiKey);if(empty($d['title'])){$errorMsg='No se encontró la película.';}else{$poster=!empty($d['poster_path'])?'https://image.tmdb.org/t/p/original'.$d['poster_path']:'';$logo='';if(!empty($d['images']['logos'])){$lg=$d['images']['logos'];foreach(['es','en'] as $l){foreach($lg as $it){if($it['iso_639_1']===$l){$logo='https://image.tmdb.org/t/p/w500'.$it['file_path'];break 2;}}}if(!$logo) $logo='https://image.tmdb.org/t/p/w500'.$lg[0]['file_path'];}$selectedMovie=['name'=>$d['title']?:$st,'icono'=>$poster,'iconoHorizontal'=>!empty($d['backdrop_path'])?'https://image.tmdb.org/t/p/original'.$d['backdrop_path']:'','iconpng'=>$logo,'descripcion'=>$d['overview']??'','anio'=>substr($d['release_date']??'',0,4),'genero'=>!empty($d['genres'])?implode(', ',array_column($d['genres'],'name')):'','duracion'=>($d['runtime']??0)?$d['runtime'].' min':''];}}

/***************************************
 * Guardar Nueva Película
 **************************************/
if(isset($_POST['action'])&&$_POST['action']==='save'){
    $newName=trim($_POST['name']);$newIcono=trim($_POST['icono']);$newUrl=encryptUrl(trim($_POST['url']));$newIconoHor=trim($_POST['iconoHorizontal']??'');$newIconpng=trim($_POST['iconpng']??'');$newDesc=trim($_POST['descripcion']??'');$newAnio=trim($_POST['anio']??'');$newGenero=trim($_POST['genero']??'');$newDuracion=trim($_POST['duracion']??'');$catSel=trim($_POST['categoria']);$catNew=trim($_POST['categoria_nueva']);
    $exists=false;foreach($jsonArray as $cat){foreach($cat['samples'] as $p){if(strcasecmp($p['name'],$newName)===0){$exists=true;break 2;}}}
    if($exists){$errorMsg="La película '$newName' ya existe.";}else{$nuevo=['name'=>$newName,'url'=>$newUrl,'icono'=>$newIcono,'iconoHorizontal'=>$newIconoHor,'iconpng'=>$newIconpng,'descripcion'=>$newDesc,'anio'=>$newAnio,'genero'=>$newGenero,'duracion'=>$newDuracion,'type'=>'PELICULA'];if($catSel==='nueva'&&$catNew!==''){$jsonArray[]=['name'=>$catNew,'samples'=>[$nuevo]];}else{foreach($jsonArray as $i=>$cat){if($cat['name']===$catSel){$jsonArray[$i]['samples'][]=$nuevo;break;}}}if(saveAllData($jsonArray, "Agregando película: $newName")){$successMsg="¡Película '$newName' agregada!";}else{$errorMsg='Error al agregar película.';}}}

/***************************************
 * Editar Película (cargar datos)
 **************************************/
$editMovieData=null;if(isset($_GET['action'])&&$_GET['action']==='editMovie'){$c=(int)($_GET['cat']??-1);$m=(int)($_GET['movie']??-1);if($c>=0&&isset($jsonArray[$c]['samples'][$m])){$p=$jsonArray[$c]['samples'][$m];$editMovieData=['catIndex'=>$c,'movieIndex'=>$m,'name'=>$p['name'],'url'=>decryptUrl($p['url']),'icono'=>$p['icono'],'iconoHorizontal'=>$p['iconoHorizontal']??'','iconpng'=>$p['iconpng']??'','descripcion'=>$p['descripcion']??'','anio'=>$p['anio']??'','genero'=>$p['genero']??'','duracion'=>$p['duracion']??''];}}

/***************************************
 * Actualizar Película (post-edit)
 **************************************/
if(isset($_POST['action'])&&$_POST['action']==='updateMovie'){$c=(int)$_POST['catIndex'];$m=(int)$_POST['movieIndex'];$newName=trim($_POST['name']);$newUrl=encryptUrl(trim($_POST['url']));$newIcono=trim($_POST['icono']);$newIconoHor=trim($_POST['iconoHorizontal']);$newIconpng=trim($_POST['iconpng']);$newDesc=trim($_POST['descripcion']);$newAnio=trim($_POST['anio']);$newGenero=trim($_POST['genero']);$newDuracion=trim($_POST['duracion']);$newPos=(int)$_POST['position'];if(isset($jsonArray[$c]['samples'][$m])){$jsonArray[$c]['samples'][$m]=array_merge($jsonArray[$c]['samples'][$m],['name'=>$newName,'url'=>$newUrl,'icono'=>$newIcono,'iconoHorizontal'=>$newIconoHor,'iconpng'=>$newIconpng,'descripcion'=>$newDesc,'anio'=>$newAnio,'genero'=>$newGenero,'duracion'=>$newDuracion]);$s=&$jsonArray[$c]['samples'];$t=$newPos-1;if($t>=0&&$t<count($s)&&$t!==$m){$p=$s[$m];array_splice($s,$m,1);array_splice($s,$t,0,[$p]);}if(saveAllData($jsonArray, "Editando película: $newName")){$successMsg="Película '$newName' editada.";}else{$errorMsg='Error al editar película.';}}}

/***************************************
 * Actualizar Categoría (posición, nombre)
 **************************************/
if(isset($_POST['action'])&&$_POST['action']==='updateCategory'){$c=(int)$_POST['catIndex'];$newPos=(int)$_POST['position'];if(isset($jsonArray[$c])){$cnt=count($jsonArray);$t=$newPos-1;if($t>=0&&$t<$cnt&&$t!==$c){$cat=$jsonArray[$c];array_splice($jsonArray,$c,1);array_splice($jsonArray,$t,0,[$cat]);if(saveAllData($jsonArray, 'Reordenando categorías')){$successMsg='Categoría movida.';}else{$errorMsg='Error al mover categoría.';}}else{$errorMsg='Posición inválida.';}}else{$errorMsg='Categoría no encontrada.';}}
if(isset($_POST['action'])&&$_POST['action']==='updateCategoryName'){$c=(int)$_POST['catIndex'];$newName=trim($_POST['newName']);if(isset($jsonArray[$c])){$oldName=$jsonArray[$c]['name'];$jsonArray[$c]['name']=$newName;if(saveAllData($jsonArray, "Renombrando categoría: $oldName -> $newName")){$successMsg='Nombre de categoría actualizado.';}else{$errorMsg='Error al actualizar nombre.';}}else{$errorMsg='Categoría no encontrada.';}}

/***************************************
 * Búsqueda dentro de JSON
 **************************************/
$localSearchResults=[];if(isset($_GET['action'])&&$_GET['action']==='searchExisting'&&!empty($_GET['query'])){$q=trim($_GET['query']);foreach($jsonArray as $ci=>$cat){foreach($cat['samples'] as $mi=>$p){if(stripos($p['name'],$q)!==false){$localSearchResults[]=['catIndex'=>$ci,'movieIndex'=>$mi,'name'=>$p['name'],'url'=>$p['url'],'icono'=>$p['icono'],'catName'=>$cat['name']];}}}}

/***************************************
 * Editor Manual de JSON (Cargar y Guardar)
 **************************************/
if (isset($_GET['action']) && $_GET['action'] === 'editJson') {
    $showJsonEditor = true;
    $tempArray = json_decode(json_encode($jsonArray), true); // Copia profunda
    foreach ($tempArray as &$category) {
        if (isset($category['samples'])) {
            foreach ($category['samples'] as &$movie) {
                if (isset($movie['url'])) $movie['url'] = decryptUrl($movie['url']);
            }
        }
    } unset($category, $movie);
    $jsonStringForTextarea = json_encode($tempArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}

if (isset($_POST['action']) && $_POST['action'] === 'saveManualJson') {
    $rawJson = $_POST['json_content'];
    $newData = json_decode($rawJson, true);

    if (json_last_error() === JSON_ERROR_NONE) {
        // 1. Encriptar las URLs en la nueva data para guardado local
        foreach ($newData as &$category) {
            if (isset($category['samples'])) {
                foreach ($category['samples'] as &$movie) {
                    if (isset($movie['url'])) $movie['url'] = encryptUrl($movie['url']);
                }
            }
        }
        unset($category, $movie);

        // 2. Guardar en el archivo local (encriptado) y verificar el resultado
        if (saveLocalJson($jsonFilePathLocal, $newData)) {
            $successMsg = 'El JSON se ha actualizado correctamente en el hosting.';
            $jsonArray = $newData; // Actualizamos el array en memoria
        } else {
            $errorMsg = 'Error al guardar el archivo JSON local.';
        }
    } else {
        $errorMsg = 'El contenido del JSON no es válido. Error: ' . json_last_error_msg();
        $showJsonEditor = true;
        $jsonStringForTextarea = $rawJson; // Mantenemos el texto para corregir
    }
}


/***************************************
 * Formularios rápidos para editar categoría
 **************************************/
$editCategoryNameData=null;$editCategoryPositionData=null;
if(isset($_GET['action'])&&$_GET['action']==='editCategoryName'){$ci=(int)($_GET['cat']??-1);if($ci>=0&&isset($jsonArray[$ci]))$editCategoryNameData=['catIndex'=>$ci,'name'=>$jsonArray[$ci]['name']];}
elseif(isset($_GET['action'])&&$_GET['action']==='editCategoryPosition'){$ci=(int)($_GET['cat']??-1);if($ci>=0&&isset($jsonArray[$ci]))$editCategoryPositionData=['catIndex'=>$ci,'name'=>$jsonArray[$ci]['name']];}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Panel Admin - Películas</title>
<style>
body{background:#f0f2f5;margin:0;padding:0;font-family:Arial,sans-serif}
.container{max-width:1100px;margin:30px auto;background:#fff;padding:25px;border-radius:8px;box-shadow:0 0 10px rgba(0,0,0,.1)}
h1,h2{margin:0 0 15px;font-weight:normal}
.error{color:#d9534f;font-weight:bold;margin-bottom:15px}
.success{color:#5cb85c;font-weight:bold;margin-bottom:15px}
.block{margin-bottom:30px;border-bottom:1px solid #dedede;padding-bottom:20px}
.block h2{font-size:1.3em;margin-bottom:10px;border-left:4px solid #007bff;padding-left:8px}
.input-group{margin-bottom:12px}
.label{display:inline-block;width:140px;font-weight:bold}
input[type=text],textarea,select{width:70%;padding:8px;box-sizing:border-box;font-size:1em;margin-left:5px;border:1px solid #ccc;border-radius:4px}
textarea{resize:vertical;height:100px;font-family:monospace;}
button{padding:10px 20px;background:#007bff;color:#fff;border:none;cursor:pointer;border-radius:4px;font-size:1em}
button:hover{background:#0056b3}
.edit-link,.button-like{display:inline-block;margin-left:8px;padding:6px 10px;background:#28a745;color:#fff!important;text-decoration:none;border-radius:4px;font-size:.9em}
.edit-link:hover,.button-like:hover{background:#218838}
.delete-link{display:inline-block;margin-left:8px;padding:6px 10px;background:#d9534f;color:#fff!important;text-decoration:none;border-radius:4px;font-size:.9em}
.delete-link:hover{background:#c9302c}
.search-results ul,.category-list ul{list-style:none;padding-left:0}
.search-results li,.category-list li{margin:5px 0}
.move-links{margin-left:10px;font-size:.9em}
.move-links a{color:#666;text-decoration:none;margin-right:4px}
.move-links a:hover{text-decoration:underline}
.divider{border-top:1px dashed #ccc;margin:15px 0}
.pos-field{width:60px!important}
.update-btn{background:#ff6600}
.update-btn:hover{background:#cc5200}
.encrypt-btn{background:#8e44ad}
.encrypt-btn:hover{background:#732d91}
.json-editor-area{width:98%;height:500px;}
</style>
</head>
<body>
<div class="container">
<h1>Panel de Administración de Películas
<?php if(!file_exists($updateFlagFile)):?>
<a href="?action=runUpdate" class="button-like update-btn" onclick="return confirm('Esta acción actualizará los datos de TODAS las películas usando TMDb y el botón desaparecerá para siempre. ¿Continuar?');">Actualizar Datos</a>
<?php endif;?>
<?php if(!file_exists($encryptionFlagFile)):?>
<a href="?action=encryptAll" class="button-like encrypt-btn" onclick="return confirm('Esta acción encriptará TODAS las URLs del archivo JSON y el botón desaparecerá para siempre. Úsalo solo una vez. ¿Continuar?');">Encriptar URLs</a>
<?php endif;?>
</h1>

<?php if($errorMsg):?><div class="error"><?=htmlspecialchars($errorMsg)?></div><?php endif;?>
<?php if($successMsg):?><div class="success"><?=htmlspecialchars($successMsg)?></div><?php endif;?>

<!-- Bloque Editor JSON Manual -->
<div class="block">
    <h2>Editor Manual de JSON</h2>
    <?php if(!$showJsonEditor): ?>
        <p>Abre el editor manual para ver y modificar el contenido completo. Las URLs se mostrarán desencriptadas para facilitar la edición. Al guardar, se actualizará el archivo local (con las URLs encriptadas automáticamente).</p>
        <a href="?action=editJson" class="button-like">Editar JSON Manualmente</a>
    <?php else: ?>
        <form method="post" action="">
            <input type="hidden" name="action" value="saveManualJson">
            <p><strong>Atención:</strong> Estás editando el JSON completo. Asegúrate de mantener la estructura correcta. Las URLs se encriptarán automáticamente al guardar.</p>
            <textarea name="json_content" class="json-editor-area"><?= htmlspecialchars($jsonStringForTextarea) ?></textarea>
            <br><br>
            <button type="submit">Guardar JSON Completo</button>
            <a href="<?= $_SERVER['PHP_SELF'] ?>" style="margin-left: 10px;">Cancelar</a>
        </form>
    <?php endif; ?>
</div>

<!-- Bloque 1: Buscar Película en TMDb -->
<div class="block">
<h2>1) Buscar Película en TMDb</h2>
<form method="get" action=""><input type="hidden" name="action" value="search"/>
<div class="input-group"><label for="query" class="label">Título:</label><input type="text" name="query" id="query" placeholder="Ej: Titanic" required/></div>
<button type="submit">Buscar</button></form>
<?php if(!empty($searchResults)):?>
<div class="search-results"><h3>Resultados de búsqueda:</h3><ul>
<?php foreach($searchResults as $r):
$title=$r['title']??'';$year=substr($r['release_date']??'',0,4);$id=$r['id'];?>
<li><?=htmlspecialchars($title)?> (<?=htmlspecialchars($year)?>) <a href="?action=select&id=<?=$id?>&st=<?=urlencode($title)?>">[Seleccionar]</a></li>
<?php endforeach;?></ul></div><?php endif;?></div>

<!-- Bloque 2: Agregar Película Seleccionada -->
<div class="block"><h2>2) Agregar Película Seleccionada</h2>
<?php if($selectedMovie):?>
<form method="post" action=""><input type="hidden" name="action" value="save"/>
<div class="input-group"><label class="label" for="name">Nombre:</label><input type="text" name="name" id="name" value="<?=htmlspecialchars($selectedMovie['name'])?>" readonly/></div>
<div class="input-group"><label class="label" for="icono">Póster:</label><input type="text" name="icono" id="icono" value="<?=htmlspecialchars($selectedMovie['icono'])?>" readonly/></div>
<div class="input-group"><label class="label" for="iconoHorizontal">Backdrop:</label><input type="text" name="iconoHorizontal" id="iconoHorizontal" value="<?=htmlspecialchars($selectedMovie['iconoHorizontal'])?>" readonly/></div>
<div class="input-group"><label class="label" for="iconpng">Logo PNG:</label><input type="text" name="iconpng" id="iconpng" value="<?=htmlspecialchars($selectedMovie['iconpng'])?>" readonly/></div>
<div class="input-group"><label class="label" for="descripcion">Sinopsis:</label><textarea name="descripcion" id="descripcion" rows="3" readonly><?=htmlspecialchars($selectedMovie['descripcion'])?></textarea></div>
<div class="input-group"><label class="label" for="anio">Año:</label><input type="text" name="anio" id="anio" value="<?=htmlspecialchars($selectedMovie['anio'])?>" readonly/></div>
<div class="input-group"><label class="label" for="genero">Género:</label><input type="text" name="genero" id="genero" value="<?=htmlspecialchars($selectedMovie['genero'])?>" readonly/></div>
<div class="input-group"><label class="label" for="duracion">Duración:</label><input type="text" name="duracion" id="duracion" value="<?=htmlspecialchars($selectedMovie['duracion'])?>" readonly/></div>
<div class="input-group"><label class="label" for="url">URL de la Película:</label><input type="text" name="url" id="url" placeholder="Enlace .mp4 o streaming" required/></div>
<div class="divider"></div><h3>Categoría</h3>
<div class="input-group"><label class="label" for="categoria">Elegir:</label><select name="categoria" id="categoria">
<?php foreach($jsonArray as $cat):?><option value="<?=htmlspecialchars($cat['name'])?>"><?=htmlspecialchars($cat['name'])?></option><?php endforeach;?>
<option value="nueva">-- Nueva categoría --</option></select></div>
<div class="input-group"><label class="label" for="categoria_nueva">Nueva cat.:</label><input type="text" name="categoria_nueva" id="categoria_nueva" placeholder="Solo si elegiste 'nueva'"/></div>
<button type="submit">Guardar en JSON</button></form>
<?php else:?><p><em>No hay película seleccionada. Realiza una búsqueda y haz clic en <strong>“Seleccionar”</strong>.</em></p><?php endif;?></div>

<!-- Bloque Buscador de Películas Existentes -->
<div class="block"><h2>Buscador de Películas Existentes</h2>
<form method="get" action=""><input type="hidden" name="action" value="searchExisting"/>
<div class="input-group"><label for="query" class="label">Buscar en JSON:</label><input type="text" name="query" id="query" placeholder="Ej: Titanic" required/></div>
<button type="submit">Buscar</button></form>
<?php if(!empty($localSearchResults)):?>
<div class="search-results"><h3>Resultados de búsqueda en JSON:</h3><ul>
<?php foreach($localSearchResults as $res):?>
<li><?=htmlspecialchars($res['name'])?> (Categoría: <?=htmlspecialchars($res['catName'])?>)
<a class="edit-link" href="?action=editMovie&cat=<?=$res['catIndex']?>&movie=<?=$res['movieIndex']?>">Editar</a>
<span class="move-links"><a href="?action=moveMovie&cat=<?=$res['catIndex']?>&movie=<?=$res['movieIndex']?>&dir=up">[↑]</a><a href="?action=moveMovie&cat=<?=$res['catIndex']?>&movie=<?=$res['movieIndex']?>&dir=down">[↓]</a></span></li>
<?php endforeach;?></ul></div>
<?php elseif(isset($_GET['action'])&&$_GET['action']==='searchExisting'):?>
<p><em>No se encontraron películas que coincidan con tu búsqueda.</em></p><?php endif;?></div>

<!-- Bloque Editar Película Existente -->
<?php if($editMovieData):?>
<div class="block"><h2>Editar Película: <?=htmlspecialchars($editMovieData['name'])?></h2>
<form method="post" action=""><input type="hidden" name="action" value="updateMovie"/>
<input type="hidden" name="catIndex" value="<?=$editMovieData['catIndex']?>"/>
<input type="hidden" name="movieIndex" value="<?=$editMovieData['movieIndex']?>"/>
<div class="input-group"><label class="label" for="name">Nombre:</label><input type="text" name="name" id="name" value="<?=htmlspecialchars($editMovieData['name'])?>"/></div>
<div class="input-group"><label class="label" for="url">URL:</label><input type="text" name="url" id="url" value="<?=htmlspecialchars($editMovieData['url'])?>"/></div>
<div class="input-group"><label class="label" for="icono">Póster:</label><input type="text" name="icono" id="icono" value="<?=htmlspecialchars($editMovieData['icono'])?>"/></div>
<div class="input-group"><label class="label" for="iconoHorizontal">Backdrop:</label><input type="text" name="iconoHorizontal" id="iconoHorizontal" value="<?=htmlspecialchars($editMovieData['iconoHorizontal'])?>"/></div>
<div class="input-group"><label class="label" for="iconpng">Logo PNG:</label><input type="text" name="iconpng" id="iconpng" value="<?=htmlspecialchars($editMovieData['iconpng'])?>"/></div>
<div class="input-group"><label class="label" for="descripcion">Sinopsis:</label><textarea name="descripcion" id="descripcion" rows="3"><?=htmlspecialchars($editMovieData['descripcion'])?></textarea></div>
<div class="input-group"><label class="label" for="anio">Año:</label><input type="text" name="anio" id="anio" value="<?=htmlspecialchars($editMovieData['anio'])?>"/></div>
<div class="input-group"><label class="label" for="genero">Género:</label><input type="text" name="genero" id="genero" value="<?=htmlspecialchars($editMovieData['genero'])?>"/></div>
<div class="input-group"><label class="label" for="duracion">Duración:</label><input type="text" name="duracion" id="duracion" value="<?=htmlspecialchars($editMovieData['duracion'])?>"/></div>
<div class="divider"></div><h3>Mover dentro de la misma categoría</h3>
<?php $cnt=count($jsonArray[$editMovieData['catIndex']]['samples']);?>
<div class="input-group"><label class="label" for="position">Posición:</label><select name="position" id="position" class="pos-field">
<?php for($i=1;$i<=$cnt;$i++):?><option value="<?=$i?>" <?=($i==($editMovieData['movieIndex']+1))?'selected':''?>><?=$i?></option><?php endfor;?></select></div>
<button type="submit">Guardar Cambios</button></form></div><?php endif;?>

<!-- Formularios inline para mover / duplicar -->
<?php if($moveMovieData):?>
<div class="block"><h2>Mover «<?=htmlspecialchars($moveMovieData['name'])?>» a otra categoría</h2>
<form method="get" action=""><input type="hidden" name="action" value="moveToCategory"/>
<input type="hidden" name="cat" value="<?=$moveMovieData['catIndex']?>"/><input type="hidden" name="movie" value="<?=$moveMovieData['movieIndex']?>"/>
<div class="input-group"><label class="label" for="targetCat">Categoría destino:</label><select name="targetCat" id="targetCat">
<?php foreach($jsonArray as $idx=>$c): if($idx!==$moveMovieData['catIndex']):?><option value="<?=$idx?>"><?=htmlspecialchars($c['name'])?></option><?php endif;endforeach;?></select></div>
<button type="submit">Mover</button></form></div><?php endif;?>
<?php if($duplicateMovieData):?>
<div class="block"><h2>Duplicar «<?=htmlspecialchars($duplicateMovieData['name'])?>» en otra categoría</h2>
<form method="get" action=""><input type="hidden" name="action" value="duplicateToCategory"/>
<input type="hidden" name="cat" value="<?=$duplicateMovieData['catIndex']?>"/><input type="hidden" name="movie" value="<?=$duplicateMovieData['movieIndex']?>"/>
<div class="input-group"><label class="label" for="targetCat">Categoría destino:</label><select name="targetCat" id="targetCat">
<?php foreach($jsonArray as $idx=>$c): if($idx!==$duplicateMovieData['catIndex']):?><option value="<?=$idx?>"><?=htmlspecialchars($c['name'])?></option><?php endif;endforeach;?></select></div>
<button type="submit">Duplicar</button></form></div><?php endif;?>

<!-- Formularios de categ -->
<?php if($editCategoryNameData):?>
<div class="block"><h2>Cambiar nombre de categoría: <?=htmlspecialchars($editCategoryNameData['name'])?></h2>
<form method="post" action=""><input type="hidden" name="action" value="updateCategoryName"/><input type="hidden" name="catIndex" value="<?=$editCategoryNameData['catIndex']?>"/>
<div class="input-group"><label class="label" for="newName">Nuevo nombre:</label><input type="text" name="newName" id="newName" required value="<?=htmlspecialchars($editCategoryNameData['name'])?>"/></div>
<button type="submit">Guardar</button></form></div><?php endif;?>
<?php if($editCategoryPositionData):?>
<div class="block"><h2>Editar posición de categoría: <?=htmlspecialchars($editCategoryPositionData['name'])?></h2>
<form method="post" action=""><input type="hidden" name="action" value="updateCategory"/><input type="hidden" name="catIndex" value="<?=$editCategoryPositionData['catIndex']?>"/>
<div class="input-group"><label class="label" for="position">Nueva posición:</label>
<?php $totalCats=count($jsonArray);?><select name="position" id="position" class="pos-field">
<?php for($i=1;$i<=$totalCats;$i++):?><option value="<?=$i?>" <?=($i==($editCategoryPositionData['catIndex']+1))?'selected':''?>><?=$i?></option><?php endfor;?></select></div>
<button type="submit">Mover</button></form></div><?php endif;?>

<!-- Listado Actual -->
<div class="block category-list"><h2>3) Listado Actual de Categorías / Películas</h2>
<?php if(empty($jsonArray)):?><p>No hay categorías cargadas.</p>
<?php else: foreach($jsonArray as $ci=>$cat):?>
<h3><?=htmlspecialchars($cat['name'])?><span class="move-links"><a href="?action=moveCategory&index=<?=$ci?>&dir=up">[↑]</a><a href="?action=moveCategory&index=<?=$ci?>&dir=down">[↓]</a></span>
<a class="edit-link" href="?action=editCategoryName&cat=<?=$ci?>">[Cambiar nombre]</a><a class="edit-link" href="?action=editCategoryPosition&cat=<?=$ci?>">[Editar posición]</a></h3>
<?php if(empty($cat['samples'])):?><p style="margin-left:20px;"><em>No hay películas en esta categoría.</em></p>
<?php else:?><ul><?php foreach($cat['samples'] as $mi=>$pel):?>
<li><?=htmlspecialchars($pel['name'])?>
<a class="edit-link" href="?action=editMovie&cat=<?=$ci?>&movie=<?=$mi?>">Editar</a>
<form method="get" style="display:inline" onsubmit="return confirm('¿Estás seguro de eliminar esta película?');">
<input type="hidden" name="action" value="deleteMovie"/><input type="hidden" name="cat" value="<?=$ci?>"/><input type="hidden" name="movie" value="<?=$mi?>"/>
<button type="submit" class="delete-link">Eliminar</button></form>
<form method="get" style="display:inline"><input type="hidden" name="action" value="showMoveMovieForm"/><input type="hidden" name="cat" value="<?=$ci?>"/>
<input type="hidden" name="movie" value="<?=$mi?>"/><button type="submit" class="edit-link">Mover a otra categoría</button></form>
<form method="get" style="display:inline"><input type="hidden" name="action" value="showDuplicateMovieForm"/><input type="hidden" name="cat" value="<?=$ci?>"/>
<input type="hidden" name="movie" value="<?=$mi?>"/><button type="submit" class="edit-link">Duplicar</button></form>
<span class="move-links"><a href="?action=moveMovie&cat=<?=$ci?>&movie=<?=$mi?>&dir=up">[↑]</a><a href="?action=moveMovie&cat=<?=$ci?>&movie=<?=$mi?>&dir=down">[↓]</a></span></li>
<?php endforeach;?></ul><?php endif;?><?php endforeach;?><?php endif;?></div>
</div>
</body>
</html>